import os.path


#  通过调用`is_root_directory`函数并传入路径参数，即可得到该路径是否为根目录的判断结果。如果返回`True`，则表示是根目录；如果返回`False`，则表示不是根目录。
# 在Windows系统中，根目录通常以驱动器加上反斜杠`\`的形式表示，例如`C:\`或`D:\`等。因此，当路径的尾部为空字符串或者只包含反斜杠`\`时，可以判断该路径为根目录。
def is_root_directory(path):
    drive, tail = os.path.splitdrive(path)
    return tail == '\\' or not bool(tail.strip('\\'))


if is_root_directory(r'd:\\'):
    print("为根目录")
else:
    print("不为目录")
